//control
function ProvinceController(provinceControl, capitalCityControl, cityControl)
{
    var self = this;
    this.provinceList = provinceControl;         //province element;
    this.capitalCityList = capitalCityControl;   //capitalcitycontrol;
    this.cityList = cityControl;                 //city element;
    
    this.provinces = new Array();
    
    this.selectedProvince;
    this.selectedCapitalCity;
    this.selectedCity;
    
    this.addProvince = function(province)
    {
        province.index = this.provinces.length;
        this.provinces.push(province);
    }
    this.setValue = function(defaultProvince, defaultCity)
    {
        for (i = 0; i < this.provinces.length; ++i)
        {
            this.selectedProvince = this.provinces[i];
            if (this.selectedProvince.name == defaultProvince)
            {
                break;
            }
        }
        var isSelected = false;
        for (i = 0; i < this.selectedProvince.childList.length; ++i)
        {
            this.selectedCapitalCity = this.selectedProvince.childList[i];
            for (j = 0; j < this.selectedCapitalCity.childList.length; ++j)
            {
                this.selectedCity = this.selectedCapitalCity.childList[j];
                if (this.selectedCity.name == defaultCity)
                {
                    isSelected = true;
                    break;
                }
            }
            if (isSelected == true)
                    break;
        }
        this.draw();
    }
    this.draw = function()
    {
        this.removeOptions(this.provinceList);
        this.removeOptions(this.capitalCityList);
        this.removeOptions(this.cityList);
        
        for (i = 0; i < this.provinces.length; ++i)
        {
            this.addOption(this.provinceList, this.provinces[i].name, this.provinces[i].id);
        }
        for (i = 0; i < this.selectedProvince.childList.length; ++i)
        {
            this.addOption(this.capitalCityList, this.selectedProvince.childList[i].name, this.selectedProvince.childList[i].id);
        }
        for (i = this.selectedCapitalCity.childList.length-1; i>=0 ; --i)
        {
            this.addOption(this.cityList, this.selectedCapitalCity.childList[i].name, this.selectedCapitalCity.childList[i].id);
        }
        this.provinceList.selectedIndex = this.selectedProvince.index;
        this.capitalCityList.selectedIndex = this.selectedCapitalCity.index;
        this.cityList.selectedIndex = this.selectedCity.index;
    }
    this.provinceList.onchange = function()
    {
        self.onProvinceChange(this.selectedIndex);
    }
    this.onProvinceChange = function(selectedIndex)
    {
        this.selectedProvince = this.provinces[selectedIndex];
        this.selectedCapitalCity = this.selectedProvince.childList[0];
        this.selectedCity = this.selectedCapitalCity.childList[0];
        
        this.draw();
    }
    this.capitalCityList.onchange = function()
    {
        self.onCapitalCityChange(this.selectedIndex);
    }
    this.onCapitalCityChange = function(selectedIndex)
    {
        this.selectedCapitalCity = this.selectedProvince.childList[selectedIndex];
        this.selectedCity = this.selectedCapitalCity.childList[0];
        
        this.draw();
    }
    this.cityList.onchange = function()
    {
        self.onCityChange(this.selectedIndex);
    }
    this.onCityChange = function(selectedIndex)
    {
        this.selectedCity = this.selectedCapitalCity.childList[selectedIndex];
        
        this.draw();
    }
    this.addOption = function(control, text, value)
    {
        var option = document.createElement('OPTION');
        option.text = text;
        option.value = value;
        control.options.add(option);
    }
    this.removeOptions = function(control)
    {
        while(control.options.length > 0)
        {
            control.options[0] = null;
        }
    }
}

//data
function Province(id, name)
{
    this.id = id;
    this.name = name;
    this.childList = new Array();
    
    this.addCapitalCity = function(capitalCity)
    {
        capitalCity.index = this.childList.length;
        this.childList.push(capitalCity);
    }
}
function CapitalCity(id, name)
{
    this.id = id;
    this.name = name;
    this.childList = new Array();
    
    this.addCity = function(id, name)
    {
        var city = new City(id, name);
        city.index = this.childList.length;
        this.childList.push(city);
    }
}
function City(id, name)
{
    this.id = id;
    this.name = name;
}

/*
  ÷
  control=getAreaControl("province","capitalcity", "city");
  control.setValue('', 'ɫ');
*/
function getAreaControl(province, capitalcity, city)
{
	var controller = new ProvinceController($(province), $(capitalcity), $(city));
	
	var p = new Province('', 'ѡʡ');
	var c = new CapitalCity('', 'ѡ');
	c.addCity('', 'СؼС');
	p.addCapitalCity(c);
	controller.addProvince(p);
    
    var p = new Province('', '');
 
  var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 
	var c = new CapitalCity('', ''); 
	c.addCity('', ''); 
	c.addCity('ά', 'ά');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ŭ', 'ŭ');
	c.addCity('ɽŭ', 'ɽŭ');
	c.addCity('ƺ', 'ƺ');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	p.addCapitalCity(c);
	var c = new CapitalCity('º徰', 'º徰');
	c.addCity('¤', '¤');
	c.addCity('', '');
	c.addCity('ӯ', 'ӯ');
	c.addCity('', '');
	c.addCity('º', 'º');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ͻ', 'Ͻ');
	c.addCity('Ρɽ', 'Ρɽ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('ֶ', 'ֶ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ҧ', 'Ҧ');
	c.addCity('', '');
	c.addCity('»', '»');
	c.addCity('˫', '˫');
	c.addCity('Ҧ', 'Ҧ');
	c.addCity('䶨', '䶨');
	c.addCity('Ĳ', 'Ĳ');
	c.addCity('ϻ', 'ϻ');
	c.addCity('Ԫı', 'Ԫı');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('˫ɴ', '˫ɴ');
	c.addCity('', '');
	c.addCity('º', 'º');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ӹ', 'ӹ');
	c.addCity('', '');
	c.addCity('ӿ', 'ӿ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ʯ', 'ʯ');
	c.addCity('Ԫ', 'Ԫ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̴', '̴');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Զ', 'Զ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ׳', 'ɽ׳');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ʤ', 'ʤ');
	c.addCity('ƺ', 'ƺ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ٲ', 'ٲ');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('˫岼', '˫岼');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ٲ', 'ٲ');
	p.addCapitalCity(c);
	var c = new CapitalCity('˼é', '˼é');
	c.addCity('', '');
	c.addCity('ǹ', 'ǹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ī', 'ī');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ն', 'ն');
	c.addCity('˼é', '˼é');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͨ', 'ͨ');
	c.addCity('³', '³');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɼ', 'ɼ');
	c.addCity('ν', 'ν');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('罭', '罭');
	c.addCity('', '');
	c.addCity('ͨ', 'ͨ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('ڳ', 'ڳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ʩ', 'ʩ');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ϫ', 'Ϫ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('Ԫ', 'Ԫ');
	c.addCity('', '');
	c.addCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('ν', 'ν');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('մ', 'մ');
	c.addCity('ʦ', 'ʦ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('½', '½');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ѱ', 'Ѱ');
	c.addCity('ʯ', 'ʯ');
	c.addCity('»Ȱ', '»Ȱ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ʹ', 'ʹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('㽭', '㽭');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
  

	var c = new CapitalCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('Ԫ', 'Ԫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƺ', 'ƺ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ȫ', 'Ȫ');
	c.addCity('ˮ', 'ˮ');
	p.addCapitalCity(c);
	var c = new CapitalCity('̨', '̨');
	c.addCity('', '');
	c.addCity('ɾ', 'ɾ');
	c.addCity('̨', '̨');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ٺ', 'ٺ');
	c.addCity('̨', '̨');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ͱ', 'Ͱ');
	c.addCity('ֽ', 'ֽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('²', '²');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͩ', 'ͩ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('̩˳', '̩˳');
	c.addCity('ĳ', 'ĳ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ͷ', 'ͷ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('Ҧ', 'Ҧ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ͩ®', 'ͩ®');
	c.addCity('ٰ', 'ٰ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('½', '½');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('ͺ', 'ͺ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ľ', 'ľ');
	c.addCity('', '');
	c.addCity('̩', '̩');
	c.addCity('Ͳɹ', 'Ͳɹ');
	c.addCity('', '');
	c.addCity('ɳ', 'ɳ');
	c.addCity('ԣ', 'ԣ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('첼', '첼');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('տ', 'տ');
	c.addCity('ؿ˹', 'ؿ˹');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɹ', 'ɹ');
	c.addCity('Ȫ', 'Ȫ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ľݹ', 'ľݹ');
	c.addCity('ͼ', 'ͼ');
	c.addCity('ľ', 'ľ');
	c.addCity('˹', '˹');
	c.addCity('̨', '̨');
	c.addCity('Ȫ', 'Ȫ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɹ', 'ɹ');
	c.addCity('Ȼ', 'Ȼ');
	c.addCity('Ǽ', 'Ǽ');
	c.addCity('̨', '̨');
	c.addCity('', '');
	c.addCity('ĩ', 'ĩ');
	c.addCity('˶', '˶');
	c.addCity('ξ', 'ξ');
	c.addCity(';', ';');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('տ¶', 'տ¶');
	c.addCity('', '');
	c.addCity('ǡ', 'ǡ');
	c.addCity('', '');
	c.addCity('ͼʲ', 'ͼʲ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ʲ', 'ʲ');
	c.addCity('ʲ', 'ʲ');
	c.addCity('踽', '踽');
	c.addCity('ɯ', 'ɯ');
	c.addCity('Ӣɳ', 'Ӣɳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('պ', 'պ');
	c.addCity('Ҷ', 'Ҷ');
	c.addCity('٤ʦ', '٤ʦ');
	c.addCity('', '');
	c.addCity('ͳ', 'ͳ');
	c.addCity('ʲ', 'ʲ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ʲ', 'ʲ');
	c.addCity('º', 'º');
	c.addCity('ƺ', 'ƺ');
	c.addCity('⳵', '⳵');
	c.addCity('', '');
	c.addCity('ݳ', 'ݳ');
	c.addCity('ɳ', 'ɳ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ī', 'ī');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ƥɽ', 'Ƥɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('³', '³');
	c.addCity('۷', '۷');
	c.addCity('пѷ', 'пѷ');
	c.addCity('³', '³');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͼľ', 'ͼľ');
	c.addCity('ͼľ', 'ͼľ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ʯ', 'ʯ');
	c.addCity('ʯ', 'ʯ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('³ľ', '³ľ');
	c.addCity('³ľ', '³ľ');
	c.addCity('³ľ', '³ľ');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('֥', '֥');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ī', 'ī');
	c.addCity('֥', '֥');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ｊ', 'Ｊ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('տ', 'տ');
	c.addCity('ľ', 'ľ');
	c.addCity('', '');
	c.addCity('ʲ', 'ʲ');
	c.addCity('', '');
	c.addCity('ٰ', 'ٰ');
	c.addCity('ڰ', 'ڰ');
	c.addCity('', '');
	c.addCity('лͨ', 'лͨ');
	c.addCity('Ƕ', 'Ƕ');
	c.addCity('¡', '¡');
	c.addCity('ľ', 'ľ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('տ', 'տ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('˿', '˿');
	c.addCity('¡', '¡');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɣ', 'ɣ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ӳ', 'Ӳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('˶', '˶');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('¡', '¡');
	c.addCity('߰', '߰');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('â', 'â');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ī񹤿', 'ī񹤿');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('ľ', 'ľ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ʯ', 'ʯ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ᶼ', 'ᶼ');
	c.addCity('¡', '¡');
	c.addCity('潭', '潭');
	c.addCity('ǿ', 'ǿ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ͭ', 'ͭ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ٲ', 'ٲ');
	c.addCity('', '');
	c.addCity('뽭', '뽭');
	c.addCity('ϴ', 'ϴ');
	c.addCity('', '');
	c.addCity('ϴ', 'ϴ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('Ĵ', 'Ĵ');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('ľ', 'ľ');
	c.addCity('', '');
	c.addCity('²', '²');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('Խ', 'Խ');
	c.addCity('ᶫ', 'ᶫ');
	c.addCity('ϲ', 'ϲ');
	c.addCity('', '');
	c.addCity('ո', 'ո');
	c.addCity('ײ', 'ײ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ѿ', 'Ѿ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('β', 'β');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɫ', 'ɫ');
	c.addCity('', '');
	c.addCity('ʯ', 'ʯ');
	c.addCity('', '');
	c.addCity('¸', '¸');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ž', 'Ž');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('¯', '¯');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ӲǼ', 'ӲǼ');
	c.addCity('ï', 'ï');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('С', 'С');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('봨', '봨');
	c.addCity('ԭ', 'ԭ');
	c.addCity('կ', 'կ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('üɽ', 'üɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('üɽ', 'üɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ű', 'Ű');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ȫ', 'ȫ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ʯ', 'ʯ');
	c.addCity('«ɽ', '«ɽ');
	c.addCity('Ű', 'Ű');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ͨ', 'ͨ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('Ͻ', 'Ͻ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('㰲', '㰲');
	c.addCity('ʤ', 'ʤ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('㰲', '㰲');
	p.addCapitalCity(c);
	var c = new CapitalCity('˱', '˱');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('˱', '˱');
	c.addCity('˱', '˱');
	p.addCapitalCity(c);
	var c = new CapitalCity('ϳ', 'ϳ');
	c.addCity('', '');
	c.addCity('ϲ', 'ϲ');
	c.addCity('¤', '¤');
	c.addCity('', '');
	c.addCity('Ӫɽ', 'Ӫɽ');
	c.addCity('', '');
	c.addCity('ϳ', 'ϳ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('崨', '崨');
	c.addCity('Ϊ', 'Ϊ');
	c.addCity('', '');
	c.addCity('н', 'н');
	c.addCity('üɽ', 'üɽ');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ڽ', 'ڽ');
	c.addCity('Զ', 'Զ');
	c.addCity('¡', '¡');
	c.addCity('', '');
	c.addCity('ڽ', 'ڽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ӣ', 'Ӣ');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ԫ', 'Ԫ');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ന', 'ന');
	c.addCity('Ԫ', 'Ԫ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ǽ', 'Ǽ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('̨', '̨');
	c.addCity('ͤ', 'ͤ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('н', 'н');
	c.addCity('޽', '޽');
	c.addCity('', '');
	c.addCity('ʲ', 'ʲ');
	c.addCity('㺺', '㺺');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ͻ', 'Ͻ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('֦', '֦');
	c.addCity('α', 'α');
	c.addCity('', '');
	c.addCity('֦', '֦');
	p.addCapitalCity(c);
	var c = new CapitalCity('Թ', 'Թ');
	c.addCity('˳', '˳');
	c.addCity('', '');
	c.addCity('Թ', 'Թ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɶ', 'ɶ');
	c.addCity('', '');
	c.addCity('ѽ', 'ѽ');
	c.addCity('˫', '˫');
	c.addCity('½', '½');
	c.addCity('ۯ', 'ۯ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɶ', 'ɶ');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('׺', '׺');
	c.addCity('', '');
	c.addCity('ʯȪ', 'ʯȪ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ƺ', 'ƺ');
	c.addCity('Ѯ', 'Ѯ');
	c.addCity('᰸', '᰸');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('Ɽ', 'Ɽ');
	c.addCity('֬', '֬');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ľ', 'ľ');
	c.addCity('', '');
	c.addCity('彧', '彧');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƺ', 'ƺ');
	c.addCity('ǿ', 'ǿ');
	c.addCity('', '');
	c.addCity('֣', '֣');
	c.addCity('ǹ', 'ǹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ӱ', 'Ӱ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('־', '־');
	c.addCity('˴', '˴');
	c.addCity('Ȫ', 'Ȫ');
	c.addCity('ӳ', 'ӳ');
	c.addCity('', '');
	c.addCity('Ӵ', 'Ӵ');
	c.addCity('', '');
	c.addCity('ӳ', 'ӳ');
	c.addCity('崨', '崨');
	c.addCity('', '');
	c.addCity('Ӱ', 'Ӱ');
	p.addCapitalCity(c);
	var c = new CapitalCity('μ', 'μ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('γ', 'γ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('ѳ', 'ѳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('μ', 'μ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('书', '书');
	c.addCity('Ǭ', 'Ǭ');
	c.addCity('', '');
	c.addCity('Ѯ', 'Ѯ');
	c.addCity('', '');
	c.addCity('ԭ', 'ԭ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ȫ', 'Ȫ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ü', 'ü');
	c.addCity('ǧ', 'ǧ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̫', '̫');
	c.addCity('¤', '¤');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͭ', 'ͭ');
	c.addCity('˾', '˾');
	c.addCity('ͭ', 'ͭ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('ɽ', 'ɽ');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ұ', 'Ұ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('۩', '۩');
	c.addCity('', '');
	c.addCity('۲', '۲');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('մ', 'մ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ĳ', 'ĳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ݷ', 'ݷ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ĳ', 'ĳ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('۰', '۰');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('Ľ', 'Ľ');
	c.addCity('ƽԭ', 'ƽԭ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('̩', '̩');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('ʳ', 'ʳ');
	c.addCity('̩', '̩');
	c.addCity('̩', '̩');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('΢ɽ', '΢ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̨', '̨');
	c.addCity('޳', '޳');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ٳ', 'ٳ');
	c.addCity('ĵ', 'ĵ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('̨', '̨');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ϼ', 'ϼ');
	c.addCity('', '');
	c.addCity('Զ', 'Զ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̨', '̨');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ϋ', 'Ϋ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ٹ', 'ٹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ϋ', 'Ϋ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ӫ', 'Ӫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ӫ', 'Ӫ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ׯ', 'ׯ');
	c.addCity('', '');
	c.addCity('ׯ', 'ׯ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ͳ', 'Ͳ');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('̨', '̨');
	c.addCity('Ͳ', 'Ͳ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ൺ', 'ൺ');
	c.addCity('ī', 'ī');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ൺ', 'ൺ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('̺', '̺');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('ɽ', 'ɽ');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ʯ¥', 'ʯ¥');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('Т', 'Т');
	p.addCapitalCity(c);
	var c = new CapitalCity('˳', '˳');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ǳ', 'ǳ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('ԫ', 'ԫ');
	c.addCity('ƽ½', 'ƽ½');
	c.addCity('', '');
	c.addCity('ϲ', 'ϲ');
	c.addCity('', '');
	c.addCity('ӽ', 'ӽ');
	c.addCity('˳', '˳');
	p.addCapitalCity(c);
	var c = new CapitalCity('ٷ', 'ٷ');
	c.addCity('', '');
	c.addCity('鶴', '鶴');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ٷ', 'ٷ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƫ', 'ƫ');
	c.addCity('̨', '̨');
	c.addCity('կ', 'կ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ԭƽ', 'ԭƽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ƽң', 'ƽң');
	c.addCity('˳', '˳');
	c.addCity('̫', '̫');
	c.addCity('', '');
	c.addCity('Ȩ', 'Ȩ');
	c.addCity('', '');
	c.addCity('ʯ', 'ʯ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('˷', '˷');
	c.addCity('', '');
	c.addCity('Ӧ', 'Ӧ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('˷', '˷');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('괨', '괨');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('ԫ', 'ԫ');
	c.addCity('ƽ˳', 'ƽ˳');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('º', 'º');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ȫ', 'Ȫ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('Ȫ', 'Ȫ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͬ', 'ͬ');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͬ', 'ͬ');
	c.addCity('ͬ', 'ͬ');
	p.addCapitalCity(c);
	var c = new CapitalCity('̫ԭ', '̫ԭ');
	c.addCity('¦', '¦');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ž', 'Ž');
	c.addCity('̫ԭ', '̫ԭ');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('㶫', '㶫');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('Ƹ', 'Ƹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ư', 'ư');
	c.addCity('޶', '޶');
	c.addCity('Ƹ', 'Ƹ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ҷ', 'Ҷ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Զ', 'Զ');
	c.addCity('', '');
	c.addCity('ɽ׳', 'ɽ׳');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ӣ', 'Ӣ');
	c.addCity('Զ', 'Զ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('⿪', '⿪');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ļ', 'Ļ');
	c.addCity('Ҫ', 'Ҫ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ï', 'ï');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ï', 'ï');
	p.addCapitalCity(c);
	var c = new CapitalCity('տ', 'տ');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('⴨', '⴨');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('տ', 'տ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('̨ɽ', '̨ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ݸ', 'ݸ');
	c.addCity('ݸ', 'ݸ');
	p.addCapitalCity(c);
	var c = new CapitalCity('β', 'β');
	c.addCity('½', '½');
	c.addCity('', '');
	c.addCity('½', '½');
	c.addCity('β', 'β');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ݶ', 'ݶ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('÷', '÷');
	c.addCity('ƽԶ', 'ƽԶ');
	c.addCity('廪', '廪');
	c.addCity('˳', '˳');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('÷', '÷');
	c.addCity('', '');
	c.addCity('÷', '÷');
	p.addCapitalCity(c);
	var c = new CapitalCity('Դ', 'Դ');
	c.addCity('Դ', 'Դ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('Ͻ', 'Ͻ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('Դ', 'Դ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ع', 'ع');
	c.addCity('Դ', 'Դ');
	c.addCity('·', '·');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('ʼ', 'ʼ');
	c.addCity('ʻ', 'ʻ');
	c.addCity('', '');
	c.addCity('ֲ', 'ֲ');
	c.addCity('ع', 'ع');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͷ', 'ͷ');
	c.addCity('ϰ', 'ϰ');
	c.addCity('ͷ', 'ͷ');
	p.addCapitalCity(c);
	var c = new CapitalCity('麣', '麣');
	c.addCity('麣', '麣');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ӻ', 'ӻ');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('Ϻ', 'Ϻ');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('Ϻ', 'Ϻ');
	c.addCity('', '');
	c.addCity('Ϻ', 'Ϻ');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('ຣ', 'ຣ');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('ɹ', 'ɹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ľ', 'ľ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ǫ', 'ǫ');
	c.addCity('ζ', 'ζ');
	c.addCity('ƶ', 'ƶ');
	c.addCity('Ӷ', 'Ӷ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ʵ', 'ʵ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ϲ', 'ϲ');
	c.addCity('', '');
	c.addCity('˺', '˺');
	c.addCity('', '');
	c.addCity('ͬ', 'ͬ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ϲ', 'ϲ');
	c.addCity('ɹ', 'ɹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͬ', 'ͬ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('ղ', 'ղ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ѭ', 'ѭ');
	c.addCity('¡', '¡');
	c.addCity('', '');
	c.addCity('ͻ', 'ͻ');
	c.addCity('ֶ', 'ֶ');
	c.addCity('ƽ', 'ƽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('ԭ', 'ԭ');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('¡', '¡');
	c.addCity('', '');
	c.addCity('ԭ', 'ԭ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ԭ', 'ԭ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('γ', 'γ');
	c.addCity('ͬ', 'ͬ');
	c.addCity('ͭϿ', 'ͭϿ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ʯɽ', 'ʯɽ');
	c.addCity('ũ', 'ũ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ʯɽ', 'ʯɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('ɹ', 'ɹ');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('˰', '˰');
	c.addCity('ƶ', 'ƶ');
	c.addCity('ƶǰ', 'ƶǰ');
	c.addCity('', '');
	c.addCity('ͻȪ', 'ͻȪ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('׶', '׶');
	c.addCity('غ', 'غ');
	c.addCity('ǰ', 'ǰ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ԭ', 'ԭ');
	c.addCity('ٺ', 'ٺ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ֹ', 'ֹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̫', '̫');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('͸', '͸');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ֺ', 'ֺ');
	p.addCapitalCity(c);
	var c = new CapitalCity('첼', '첼');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ǰ', 'ǰ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̶', '̶');
	c.addCity('׿', '׿');
	c.addCity('˺', '˺');
	c.addCity('', '');
	c.addCity('첼', '첼');
	p.addCapitalCity(c);
	var c = new CapitalCity('ױ', 'ױ');
	c.addCity('¿', '¿');
	c.addCity('ĪߴӶ', 'ĪߴӶ');
	c.addCity('״', '״');
	c.addCity('°Ͷ', '°Ͷ');
	c.addCity('°Ͷ', '°Ͷ');
	c.addCity('', '');
	c.addCity('°Ͷ', '°Ͷ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ʯ', 'ʯ');
	c.addCity('', '');
	c.addCity('ױ', 'ױ');
	p.addCapitalCity(c);
	var c = new CapitalCity('˹', '˹');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('пǰ', 'пǰ');
	c.addCity('п', 'п');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('׼', '׼');
	c.addCity('˹', '˹');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͨ', 'ͨ');
	c.addCity('³', '³');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƶ', 'ƶ');
	c.addCity('ƶ', 'ƶ');
	c.addCity('³', '³');
	c.addCity('ֹ', 'ֹ');
	c.addCity('ͨ', 'ͨ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ʲ', 'ʲ');
	c.addCity('ţ', 'ţ');
	c.addCity('³ƶ', '³ƶ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ں', 'ں');
	c.addCity('ں', 'ں');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͷ', 'ͷ');
	c.addCity('ï', 'ï');
	c.addCity('Ĭ', 'Ĭ');
	c.addCity('', '');
	c.addCity('ͷ', 'ͷ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͺ', 'ͺ');
	c.addCity('Ĭ', 'Ĭ');
	c.addCity('ָ', 'ָ');
	c.addCity('䴨', '䴨');
	c.addCity('ˮ', 'ˮ');
	c.addCity('п', 'п');
	c.addCity('ͺ', 'ͺ');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('ɹ', 'ɹ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('Ʊ', 'Ʊ');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ͼ', 'ͼ');
	c.addCity('', '');
	c.addCity('ԭ', 'ԭ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ɹ', 'ɹ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('̽', '̽');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('̽', '̽');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ӫ', 'Ӫ');
	c.addCity('', '');
	c.addCity('ʯ', 'ʯ');
	c.addCity('Ӫ', 'Ӫ');
	p.addCapitalCity(c);
	var c = new CapitalCity('«', '«');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('˳', '˳');
	c.addCity('«', '«');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('躣', '躣');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('Ϫ', 'Ϫ');
	p.addCapitalCity(c);
	var c = new CapitalCity('˳', '˳');
	c.addCity('±', '±');
	c.addCity('ԭ', 'ԭ');
	c.addCity('˳', '˳');
	c.addCity('˳', '˳');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('̨', '̨');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ׯ', 'ׯ');
	c.addCity('', '');
	c.addCity('߷', '߷');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('߮', '߮');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ǧɽ', 'Ǧɽ');
	c.addCity('Դ', 'Դ');
	c.addCity('۶', '۶');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('质', '质');
	c.addCity('', '');
	c.addCity('˻', '˻');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('ϳ', 'ϳ');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('ְ', 'ְ');
	c.addCity('Ϸ', 'Ϸ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('˴', '˴');
	c.addCity('ϸ', 'ϸ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('˷', '˷');
	c.addCity('', '');
	c.addCity('ͭ', 'ͭ');
	c.addCity('߰', '߰');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('˴', '˴');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('촨', '촨');
	c.addCity('Ͽ', 'Ͽ');
	c.addCity('̩', '̩');
	c.addCity('¸', '¸');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ȫ', 'ȫ');
	c.addCity('ŷ', 'ŷ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ڶ', 'ڶ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('˹', '˹');
	c.addCity('Ѱ', 'Ѱ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Զ', 'Զ');
	c.addCity('ʯ', 'ʯ');
	c.addCity('Ͽ', 'Ͽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ӥ̶', 'ӥ̶');
	c.addCity('཭', '཭');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('ӥ̶', 'ӥ̶');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ž', 'Ž');
	c.addCity('', '');
	c.addCity('°', '°');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ž', 'Ž');
	c.addCity('', '');
	c.addCity('Ž', 'Ž');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ƽ', 'Ƽ');
	c.addCity('«Ϫ', '«Ϫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ƽ', 'Ƽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ϲ', 'ϲ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ϲ', 'ϲ');
	c.addCity('½', '½');
	c.addCity('ϲ', 'ϲ');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('⽭', '⽭');
	c.addCity('ɽ', 'ɽ');
	c.addCity('̫', '̫');
	c.addCity('żҸ', 'żҸ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('̳', '̳');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͨ', 'ͨ');
	c.addCity('綫', '綫');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('ͨ', 'ͨ');
	p.addCapitalCity(c);
	var c = new CapitalCity('̩', '̩');
	c.addCity('˻', '˻');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̩', '̩');
	c.addCity('̩', '̩');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ӧ', 'Ӧ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('γ', 'γ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('ζ', 'ζ');
	c.addCity('', '');
	c.addCity('̨', '̨');
	c.addCity('γ', 'γ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ǩ', 'Ǩ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ԥ', 'ԥ');
	c.addCity('Ǩ', 'Ǩ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ƹ', 'Ƹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ƹ', 'Ƹ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͭɽ', 'ͭɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ͼ', 'Ͼ');
	c.addCity('ߴ', 'ߴ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('Ͼ', 'Ͼ');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('ӱ߳', 'ӱ߳');
	c.addCity('', '');
	c.addCity('ͼ', 'ͼ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ػ', 'ػ');
	c.addCity('ͼ', 'ͼ');
	c.addCity('Ӽ', 'Ӽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('׳', '׳');
	c.addCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('׳', '׳');
	p.addCapitalCity(c);
	var c = new CapitalCity('ԭ', 'ԭ');
	c.addCity('ǰ˹ɹ', 'ǰ˹ɹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ǭ', 'Ǭ');
	c.addCity('ԭ', 'ԭ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('׳', '׳');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ٽ', 'ٽ');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('÷ӿ', '÷ӿ');
	c.addCity('ͨ', 'ͨ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ƽ', 'ƽ');
	c.addCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('˫', '˫');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ʯ', 'ʯ');
	c.addCity('Ժ', 'Ժ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ũ', 'ũ');
	c.addCity('»', '»');
	c.addCity('', '');
	c.addCity('̨', '̨');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('ԫ', 'ԫ');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('˳', '˳');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('¦', '¦');
	c.addCity('˫', '˫');
	c.addCity('»', '»');
	c.addCity('Դ', 'Դ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('¦', '¦');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('嶱', '嶱');
	c.addCity('ͨ', 'ͨ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('»ζ', '»ζ');
	c.addCity('з', 'з');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('ͬ', 'ͬ');
	c.addCity('齭', '齭');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('˫', '˫');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Զ', 'Զ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('κ', 'κ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ҽ', 'ҽ');
	c.addCity('佭', '佭');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('żҽ', 'żҽ');
	c.addCity('ɣֲ', 'ɣֲ');
	c.addCity('', '');
	c.addCity('żҽ', 'żҽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ʯ', 'ʯ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ǲ', 'ǲ');
	c.addCity('¡', '¡');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('۶', '۶');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ⶫ', 'ⶫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('̶', '̶');
	c.addCity('̶', '̶');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('̶', '̶');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɳ', 'ɳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɳ', 'ɳ');
	c.addCity('', '');
	c.addCity('ɳ', 'ɳ');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('ʩ', 'ʩ');
	c.addCity('̷', '̷');
	c.addCity('', '');
	c.addCity('׷', '׷');
	c.addCity('Ͷ', 'Ͷ');
	c.addCity('', '');
	c.addCity('ʼ', 'ʼ');
	c.addCity('', '');
	c.addCity('ʩ', 'ʩ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ũ', 'ũ');
	c.addCity('ũ', 'ũ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ǳ', 'Ǳ');
	c.addCity('Ǳ', 'Ǳ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('ͨɽ', 'ͨɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ƹ', 'Ƹ');
	c.addCity('ŷ', 'ŷ');
	c.addCity('Ӣɽ', 'Ӣɽ');
	c.addCity('÷', '÷');
	c.addCity('ޭ', 'ޭ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('찲', '찲');
	c.addCity('Ѩ', 'Ѩ');
	c.addCity('', '');
	c.addCity('Ƹ', 'Ƹ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Т', 'Т');
	c.addCity('Т', 'Т');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('½', '½');
	c.addCity('Ӧ', 'Ӧ');
	c.addCity('Т', 'Т');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ɳ', 'ɳ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('˲', '˲');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('Զ', 'Զ');
	c.addCity('', '');
	c.addCity('֦', '֦');
	c.addCity('', '');
	c.addCity('˶', '˶');
	c.addCity('˲', '˲');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ʯ', 'ʯ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ʮ', 'ʮ');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ʮ', 'ʮ');
	p.addCapitalCity(c);
	var c = new CapitalCity('差', '差');
	c.addCity('', '');
	c.addCity('ȳ', 'ȳ');
	c.addCity('', '');
	c.addCity('˳', '˳');
	c.addCity('', '');
	c.addCity('Ϻӿ', 'Ϻӿ');
	c.addCity('差', '差');
	p.addCapitalCity(c);
	var c = new CapitalCity('ʯ', 'ʯ');
	c.addCity('', '');
	c.addCity('ұ', 'ұ');
	c.addCity('ʯ', 'ʯ');
	p.addCapitalCity(c);
	var c = new CapitalCity('人', '人');
	c.addCity('人', '人');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('˰', '˰');
	c.addCity('˰', '˰');
	c.addCity('Ӹ', 'Ӹ');
	c.addCity('Į', 'Į');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('绯', '绯');
	c.addCity('', '');
	c.addCity('찲', '찲');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ض', 'ض');
	c.addCity('', '');
	c.addCity('绯', '绯');
	p.addCapitalCity(c);
	var c = new CapitalCity('ں', 'ں');
	c.addCity('', '');
	c.addCity('۽', '۽');
	c.addCity('ѷ', 'ѷ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ں', 'ں');
	p.addCapitalCity(c);
	var c = new CapitalCity('̨', '̨');
	c.addCity('', '');
	c.addCity('̨', '̨');
	p.addCapitalCity(c);
	var c = new CapitalCity('ľ˹', 'ľ˹');
	c.addCity('ԭ', 'ԭ');
	c.addCity('', '');
	c.addCity('Զ', 'Զ');
	c.addCity('봨', '봨');
	c.addCity('', '');
	c.addCity('ͬ', 'ͬ');
	c.addCity('ľ˹', 'ľ˹');
	p.addCapitalCity(c);
	var c = new CapitalCity('ĵ', 'ĵ');
	c.addCity('', '');
	c.addCity('ֿ', 'ֿ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Һ', 'Һ');
	c.addCity('ĵ', 'ĵ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ŷɹ', 'Ŷɹ');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('ֵ', 'ֵ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('˫Ѽɽ', '˫Ѽɽ');
	c.addCity('ĺ', 'ĺ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('˫Ѽɽ', '˫Ѽɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('׸', '׸');
	c.addCity('', '');
	c.addCity('ܱ', 'ܱ');
	c.addCity('׸', '׸');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('˶', '˶');
	c.addCity('̩', '̩');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ȫ', 'Ȫ');
	c.addCity('ԣ', 'ԣ');
	c.addCity('ګ', 'ګ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ľ', 'ľ');
	c.addCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('峣', '峣');
	c.addCity('˫', '˫');
	c.addCity('־', '־');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('Դ', 'Դ');
	c.addCity('Դ', 'Դ');
	p.addCapitalCity(c);
	var c = new CapitalCity('פ', 'פ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ϲ', 'ϲ');
	c.addCity('²', '²');
	c.addCity('ȷɽ', 'ȷɽ');
	c.addCity('פ', 'פ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ܿ', 'ܿ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('¹', '¹');
	c.addCity('̫', '̫');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('ܿ', 'ܿ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ʼ', 'ʼ');
	c.addCity('̳', '̳');
	c.addCity('', '');
	c.addCity('Ϣ', 'Ϣ');
	c.addCity('', '');
	c.addCity('괨', '괨');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ϳ', 'ϳ');
	c.addCity('', '');
	c.addCity('Ȩ', 'Ȩ');
	c.addCity('ݳ', 'ݳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ͽ', 'Ͽ');
	c.addCity('', '');
	c.addCity('Ұ', 'Ұ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƺ', 'ƺ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͩ', 'ͩ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ͽ', 'Ͽ');
	c.addCity('', '');
	c.addCity('¬', '¬');
	c.addCity('ų', 'ų');
	c.addCity('鱦', '鱦');
	c.addCity('', '');
	c.addCity('Ͽ', 'Ͽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('۱', '۱');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('۳', '۳');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̨ǰ', '̨ǰ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ڻ', 'ڻ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ӽ', 'ӽ');
	c.addCity('', '');
	c.addCity('ԫ', 'ԫ');
	c.addCity('ԭ', 'ԭ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ױ', 'ױ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ױ', 'ױ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ƽɽ', 'ƽɽ');
	c.addCity('³ɽ', '³ɽ');
	c.addCity('ۣ', 'ۣ');
	c.addCity('Ҷ', 'Ҷ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƽɽ', 'ƽɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ﴨ', 'ﴨ');
	c.addCity('°', '°');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ͻ', 'Ͻ');
	c.addCity('ʦ', 'ʦ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ͨ', 'ͨ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ξ', 'ξ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('֣', '֣');
	c.addCity('Ĳ', 'Ĳ');
	c.addCity('', '');
	c.addCity('Ƿ', 'Ƿ');
	c.addCity('', '');
	c.addCity('֣', '֣');
	c.addCity('', '');
	c.addCity('֣', '֣');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('ӱ', 'ӱ');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('ˮ', 'ˮ');
	c.addCity('ǿ', 'ǿ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('ʳ', 'ʳ');
	c.addCity('ǿ', 'ǿ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ȷ', 'ȷ');
	c.addCity('󳧻', '󳧻');
	c.addCity('İ', 'İ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̰', '̰');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ȷ', 'ȷ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ϴ', 'ϴ');
	c.addCity('', '');
	c.addCity('Ƥ', 'Ƥ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ӽ', 'Ӽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͷ', 'ͷ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('е', 'е');
	c.addCity('', '');
	c.addCity('Χɹ', 'Χɹ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ƽȪ', 'ƽȪ');
	c.addCity('¡', '¡');
	c.addCity('¡', '¡');
	c.addCity('е', 'е');
	c.addCity('е', 'е');
	p.addCapitalCity(c);
	var c = new CapitalCity('żҿ', 'żҿ');
	c.addCity('ȫ', 'ȫ');
	c.addCity('¹', '¹');
	c.addCity('ε', 'ε');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('ԭ', 'ԭ');
	c.addCity('ű', 'ű');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('żҿ', 'żҿ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('Ұ', 'Ұ');
	c.addCity('˳ƽ', '˳ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('ݳ', 'ݳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('Է', 'Է');
	c.addCity('', '');
	c.addCity('߱', '߱');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('̨', '̨');
	c.addCity('Ϻ', 'Ϻ');
	c.addCity('º', 'º');
	c.addCity('¹', '¹');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ٳ', 'ٳ');
	c.addCity('¡Ң', '¡Ң');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̨', '̨');
	c.addCity('ɳ', 'ɳ');
	c.addCity('Ϲ', 'Ϲ');
	c.addCity('̨', '̨');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɰ', 'ɰ');
	c.addCity('κ', 'κ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('䰲', '䰲');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ػʵ', 'ػʵ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('¬', '¬');
	c.addCity('', '');
	c.addCity('ػʵ', 'ػʵ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('ͤ', 'ͤ');
	c.addCity('ƺ', 'ƺ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ǩ', 'Ǩ');
	c.addCity('Ǩ', 'Ǩ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ʯׯ', 'ʯׯ');
	c.addCity('Ԫ', 'Ԫ');
	c.addCity('޼', '޼');
	c.addCity('', '');
	c.addCity('޻', '޻');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƽɽ', 'ƽɽ');
	c.addCity('¹Ȫ', '¹Ȫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('޻', '޻');
	c.addCity('', '');
	c.addCity('ʯׯ', 'ʯׯ');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͤ', 'ͤ');
	c.addCity('ͤ', 'ͤ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ˮ', 'ˮ');
	c.addCity('ˮ', 'ˮ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ֶ', 'ֶ');
	c.addCity('ֶ', 'ֶ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɳ', 'ɳ');
	c.addCity('ɳ', 'ɳ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ٸ', 'ٸ');
	c.addCity('ٸ', 'ٸ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ͳ', 'Ͳ');
	c.addCity('Ͳ', 'Ͳ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ĳ', 'Ĳ');
	c.addCity('Ĳ', 'Ĳ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ָɽ', 'ָɽ');
	c.addCity('ָɽ', 'ָɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('ǭϲ', 'ǭϲ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('˳', '˳');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ͱ', 'Ͱ');
	c.addCity('޵', '޵');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	c.addCity('Ȫ', 'Ȫ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ǭ嶱', 'ǭ嶱');
	c.addCity('կ', 'կ');
	c.addCity('᯹', '᯹');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ž', 'Ž');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('̨', '̨');
	c.addCity('齭', '齭');
	c.addCity('Զ', 'Զ');
	c.addCity('', '');
	c.addCity('ӽ', 'ӽ');
	c.addCity('ʩ', 'ʩ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ǭϲ', 'ǭϲ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('¡', '¡');
	c.addCity('', '');
	c.addCity('հ', 'հ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ͻ', 'Ͻ');
	c.addCity('', '');
	c.addCity('Ӻ', 'Ӻ');
	c.addCity('', '');
	c.addCity('ɳ', 'ɳ');
	c.addCity('֯', '֯');
	c.addCity('', '');
	c.addCity('ǭ', 'ǭ');
	c.addCity('Ͻ', 'Ͻ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͭ', 'ͭ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('غ', 'غ');
	c.addCity('ӡ', 'ӡ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ʯ', 'ʯ');
	c.addCity('˼', '˼');
	c.addCity('', '');
	c.addCity('½', '½');
	c.addCity('ͭ', 'ͭ');
	p.addCapitalCity(c);
	var c = new CapitalCity('˳', '˳');
	c.addCity('벼', '벼');
	c.addCity('岼', '岼');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ն', 'ն');
	c.addCity('˳', '˳');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̶', '̶');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ϰˮ', 'ϰˮ');
	c.addCity('ͩ', 'ͩ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ʻ', 'ʻ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ˮ', 'ˮ');
	c.addCity('֦', '֦');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('ˮ', 'ˮ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ϣ', 'Ϣ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƾ', 'ƾ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ó', 'ó');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ӳ', 'ӳ');
	c.addCity('', '');
	c.addCity('ë', 'ë');
	c.addCity('', '');
	c.addCity('޳', '޳');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ϵ', 'ϵ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ӳ', 'ӳ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɫ', 'ɫ');
	c.addCity('¡ָ', '¡ָ');
	c.addCity('', '');
	c.addCity('ﶫ', 'ﶫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('±', '±');
	c.addCity('ҵ', 'ҵ');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('ɫ', 'ɫ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ҵ', 'ҵ');
	c.addCity('', '');
	c.addCity('½', '½');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ֱ', 'ֱ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ǹ', 'Ǹ');
	c.addCity('˼', '˼');
	c.addCity('', '');
	c.addCity('Ǹ', 'Ǹ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ʤ', 'ʤ');
	c.addCity('', '');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('˰', '˰');
	c.addCity('ƽ', 'ƽ');
	c.addCity('ȫ', 'ȫ');
	c.addCity('鴨', '鴨');
	c.addCity('ٹ', 'ٹ');
	c.addCity('˷', '˷');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('ڰ', 'ڰ');
	c.addCity('¹կ', '¹կ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('¡', '¡');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('Ļ', 'Ļ');
	c.addCity('ʯɽ嶫', 'ʯɽ嶫');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ϲ', 'ϲ');
	c.addCity('ĺ', 'ĺ');
	c.addCity('µ', 'µ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('׿', '׿');
	c.addCity('̶', '̶');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('¤', '¤');
	c.addCity('', '');
	c.addCity('崲', '崲');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('䶼', '䶼');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͨμ', 'ͨμ');
	c.addCity('¤', '¤');
	c.addCity('μԴ', 'μԴ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ˮ', 'ˮ');
	c.addCity('ԭ', 'ԭ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ȫ', 'Ȫ');
	c.addCity('౱ɹ', '౱ɹ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ػ', 'ػ');
	c.addCity('', '');
	c.addCity('Ȫ', 'Ȫ');
	p.addCapitalCity(c);
	var c = new CapitalCity('ƽ', 'ƽ');
	c.addCity('ׯ', 'ׯ');
	c.addCity('', '');
	c.addCity('ͤ', 'ͤ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̨', '̨');
	c.addCity('ƽ', 'ƽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ҵ', 'Ҵ');
	c.addCity('ԣ', 'ԣ');
	c.addCity('̨', '̨');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('Ҵ', 'Ҵ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ף', 'ף');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ˮ', 'ˮ');
	c.addCity('żҴ', 'żҴ');
	c.addCity('ذ', 'ذ');
	c.addCity('ˮ', 'ˮ');
	c.addCity('ʹ', 'ʹ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('ˮ', 'ˮ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('̩', '̩');
	c.addCity('Զ', 'Զ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ϼ', 'ϼ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ϻ', 'Ϻ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('͡', '͡');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('ֳ', 'ֳ');
	c.addCity('˳', '˳');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ƽ', 'ƽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('̩', '̩');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('گ', 'گ');
	c.addCity('Ͼ', 'Ͼ');
	c.addCity('ƽ', 'ƽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ȫ', 'Ȫ');
	c.addCity('', '');
	c.addCity('»', '»');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('ݰ', 'ݰ');
	c.addCity('ϰ', 'ϰ');
	c.addCity('', '');
	c.addCity('ʯʨ', 'ʯʨ');
	c.addCity('Ȫ', 'Ȫ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('̩', '̩');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('ɳ', 'ɳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ƽ̶', 'ƽ̶');
	c.addCity('Դ', 'Դ');
	c.addCity('', '');
	c.addCity('̩', '̩');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	controller.addProvince(p);
	
	var p = new Province('', '');
 
	var c = new CapitalCity('','ȫ');
  c.addCity('', 'ȫ');
  p.addCapitalCity(c);
 

	var c = new CapitalCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('캵', '캵');
	c.addCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ʯ̨', 'ʯ̨');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('ɳ', 'ɳ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('կ', 'կ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('®', '®');
	c.addCity('Ϊ', 'Ϊ');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('̫', '̫');
	c.addCity('', '');
	c.addCity('ӱ', 'ӱ');
	c.addCity('Ȫ', 'Ȫ');
	c.addCity('', '');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('Զ', 'Զ');
	c.addCity('', '');
	c.addCity('ȫ', 'ȫ');
	c.addCity('', '');
	c.addCity('쳤', '쳤');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ǳɽ', 'Ǳɽ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('̫', '̫');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ͩ', 'ͩ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ͭ', 'ͭ');
	c.addCity('ͭ', 'ͭ');
	c.addCity('ͭ', 'ͭ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('Ϫ', 'Ϫ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ɽ', 'ɽ');
	c.addCity('Ϳ', 'Ϳ');
	c.addCity('ɽ', 'ɽ');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('̨', '̨');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('', '');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('Զ', 'Զ');
	c.addCity('', '');
	p.addCapitalCity(c);
	var c = new CapitalCity('ߺ', 'ߺ');
	c.addCity('', '');
	c.addCity('', '');
	c.addCity('ߺ', 'ߺ');
	c.addCity('ߺ', 'ߺ');
	p.addCapitalCity(c);
	var c = new CapitalCity('Ϸ', 'Ϸ');
	c.addCity('', '');
	c.addCity('ʶ', 'ʶ');
	c.addCity('', '');
	c.addCity('Ϸ', 'Ϸ');
	p.addCapitalCity(c);
	controller.addProvince(p);

	return controller; 
}

function $() 
{
  var elements = new Array();

  for (var i = 0; i < arguments.length; i++) 
  {
    var element = arguments[i];
    if (typeof element == 'string')
      element = document.getElementById(element);

    if (arguments.length == 1)
      return element;

    elements.push(element);
  }

  return elements;
}